unit CD;

interface

uses MMSystem,Dialogs,SysUtils;

function OpenCD(Drive :String) :Boolean;
function CloseCD(Drive :String) :Boolean;

function OpenDefaultCDAudio :Boolean;
function CloseDefaultCDAudio :Boolean;

function IsCDAudio(Drive :String) :Boolean;
function PlayCDAudio(Drive :String) :Boolean;
function ResumeCDAudio(Drive :String) :Boolean;
function PauseCDAudio(Drive :String) :Boolean;
function StopCDAudio(Drive :String) :Boolean;
function StanCDAudio(Drive :String): Integer;

//function PlayCDAudio(Sciezka :Integer) :Boolean;
procedure UstalPoziomGlosnosciCDAudio(KanalLewy,KanalPrawy :Byte);
procedure CzytajPoziomGlosnosciCDAudio(var KanalLewy :Byte; var KanalPrawy :Byte);

implementation


{ -------------- KONTROLA TACKI CD/DVD -------------- }


function KontrolaTackiCD(Drive :String; Operacja :Boolean) :Boolean;
var parametry: TMCI_Open_Parms;
begin
Result:=False;

parametry.dwCallback:=0; //uchwyt okna, do ktorego moglyby byc wysylane komunikaty powiadamiajace o wysunieciu tacki
parametry.lpstrDeviceType:='CDAudio';
parametry.lpstrElementName:=PChar(Drive); //Symbol dysku w formacie X:

//Inicjalizacja urzadzenia
mciSendCommand(0,MCI_OPEN,MCI_OPEN_ELEMENT or MCI_OPEN_TYPE,Longint(@parametry));

if Operacja then
  //Otwieranie napedu CDROM
  Result:=(mciSendCommand(parametry.wDeviceID,MCI_SET,MCI_SET_DOOR_OPEN,0)=0)
  else
  //Zamykanie napedu CDROM
  mciSendCommand(parametry.wDeviceID,MCI_SET,MCI_SET_DOOR_CLOSED,0);

//zwolnienie dostepu do urzadzenia
mciSendCommand(parametry.wDeviceID,MCI_CLOSE,MCI_NOTIFY,Longint(@parametry));
end;

function OpenCD(Drive :String) :Boolean;
begin
Result:=KontrolaTackiCD(Drive,True);
end;

function CloseCD(Drive :String) :Boolean;
begin
Result:=KontrolaTackiCD(Drive,False);
end;

function OpenDefaultCDAudio :Boolean;
begin
Result:=(mciSendString('set cdaudio door open wait',nil,0,0)=0);
end;

function CloseDefaultCDAudio :Boolean;
begin
Result:=(mciSendString('set cdaudio door closed wait',nil,0,0)=0);
end;


{ -------------- CDAudio -------------- }


function StanCDAudio(Drive :String): Integer;
var
  parametry: TMCI_Open_Parms;
  stan: TMCI_Status_Parms;
begin
parametry.dwCallback:=0;
parametry.lpstrDeviceType:='CDAudio';
parametry.lpstrElementName:=PChar(Drive); //Litera dysku musi by np. "X:"
mciSendCommand(0,MCI_OPEN,MCI_OPEN_ELEMENT or MCI_OPEN_TYPE,Longint(@parametry));

stan.dwItem:=mci_Status_Mode;
mciSendCommand(parametry.wDeviceID,MCI_STATUS,MCI_WAIT or MCI_STATUS_ITEM,Longint(@stan));
Result:=stan.dwReturn; {stan MCI zaczyna sie od 524}

mciSendCommand(parametry.wDeviceID,MCI_CLOSE,MCI_NOTIFY,Longint(@parametry));
end;


function IsCDAudio(Drive :String) :Boolean;
var
  parametry: TMCI_Open_Parms;
  stanNapedu : TMCI_Status_Parms;
  identyfikator : MCIDeviceID;
  mciBlad :LongInt;
begin
Result:=False;

parametry.dwCallback:=0;
parametry.lpstrDeviceType:='CDAudio';
parametry.lpstrElementName:=PChar(Drive);
mciBlad:=mciSendCommand(0,MCI_OPEN,MCI_OPEN_ELEMENT or MCI_OPEN_TYPE,Longint(@parametry));
if mciBlad<>0 then Exit;

stanNapedu.dwCallback:=0;
stanNapedu.dwItem:=MCI_CDA_STATUS_TYPE_TRACK;
stanNapedu.dwTrack:=1;
mciBlad:=mciSendCommand(parametry.wDeviceID,MCI_STATUS,MCI_TRACK or MCI_STATUS_ITEM,Longint(@stanNapedu));
if mciBlad<>0 then Exit;

case stanNapedu.dwReturn of
  MCI_CDA_TRACK_AUDIO: Result:=True;
  else
  Result:=False;
  end;

mciSendCommand(parametry.wDeviceID,MCI_CLOSE,MCI_NOTIFY,Longint(@parametry));
end;


function KontrolaCDAudio(Drive :String; Operacja :Cardinal) :Boolean;
var parametry: TMCI_Open_Parms;
begin
parametry.dwCallback:=0;
parametry.lpstrDeviceType:='CDAudio';
parametry.lpstrElementName:=PChar(Drive); //Litera dysku musi by np. "X:"
mciSendCommand(0,MCI_OPEN,MCI_OPEN_ELEMENT or MCI_OPEN_TYPE,Longint(@parametry));

Result:=(mciSendCommand(parametry.wDeviceID,Operacja,0,0)=0);

mciSendCommand(parametry.wDeviceID,MCI_CLOSE,MCI_NOTIFY,Longint(@parametry));
end;


function PlayCDAudio(Drive :String) :Boolean;
begin
Result:=KontrolaCDAudio(Drive,MCI_PLAY);
end;

function ResumeCDAudio(Drive :String) :Boolean;
begin
Result:=KontrolaCDAudio(Drive,MCI_RESUME);
end;

function PauseCDAudio(Drive :String) :Boolean;
begin
if StanCDAudio(Drive)<>525
  then Result:=KontrolaCDAudio(Drive,MCI_PAUSE) //gdy odtwarzanie
  else Result:=ResumeCDAudio(Drive); //gdy zatrzymany
end;

function StopCDAudio(Drive :String) :Boolean;
begin
Result:=KontrolaCDAudio(Drive,MCI_STOP);
end;


{ -------------- Poziom glosnosci CDAudio -------------- }


procedure UstalPoziomGlosnosciCDAudio(kanalLewy,kanalPrawy :Byte);
begin
auxSetVolume(AUX_MAPPER,Integer((kanalLewy shl 24) or (kanalPrawy shl 8)));
end;

procedure CzytajPoziomGlosnosciCDAudio(var KanalLewy :Byte; var KanalPrawy :Byte);
var glosnosc :Cardinal;
begin
auxGetVolume(AUX_MAPPER,@glosnosc);
kanalLewy:=Byte(glosnosc shr 24);
kanalPrawy:=Byte(glosnosc shr 8);
end;

end.

